unit SimpleEcoWebDemoEcoSpace;

interface

uses
  System.Threading,
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.Persistence,
 
  Borland.Eco.Handles,
  CoreClassesUnit;

type
  [EcoSpace]
  [EcoSpacePackage(TypeOf(CoreClassesUnit.CoreClasses))]
  TSimpleEcoWebDemoEcoSpace = class(Borland.Eco.Handles.DefaultEcoSpace)
  strict private
    procedure InitializeComponent;
  private
    PersistenceMapperSharer1: Borland.Eco.Persistence.PersistenceMapperSharer;
    class var fTypeSystemProvider: ITypeSystemService;
    class var fTypeSystemProviderLock: Tobject;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

implementation

uses
  EcoPersistenceMapperProvider ;

constructor TSimpleEcoWebDemoEcoSpace.Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

class constructor TSimpleEcoWebDemoEcoSpace.Create;
begin
  fTypeSystemProviderLock := TObject.Create;
end;

class function TSimpleEcoWebDemoEcoSpace.GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(fTypeSystemProvider) then
  begin
    try
      Monitor.Enter(fTypeSystemProviderLock);
      if not Assigned(fTypeSystemProvider) then
        fTypeSystemProvider := MakeTypeService(typeOf(TSimpleEcoWebDemoEcoSpace));
    finally
      Monitor.Exit(fTypeSystemProviderLock);
    end;
  end;
  Result := fTypeSystemProvider;
end;

function TSimpleEcoWebDemoEcoSpace.GetTypeSystemProvider: ITypeSystemService;
begin
  Result := TSimpleEcoWebDemoEcoSpace.GetTypeSystemService;
end;

procedure TSimpleEcoWebDemoEcoSpace.UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function TSimpleEcoWebDemoEcoSpace.get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function TSimpleEcoWebDemoEcoSpace.get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function TSimpleEcoWebDemoEcoSpace.get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function TSimpleEcoWebDemoEcoSpace.get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function TSimpleEcoWebDemoEcoSpace.get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function TSimpleEcoWebDemoEcoSpace.get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function TSimpleEcoWebDemoEcoSpace.get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

procedure TSimpleEcoWebDemoEcoSpace.InitializeComponent;
begin
  Self.PersistenceMapperSharer1 := Borland.Eco.Persistence.PersistenceMapperSharer.Create;
  // 
  // PersistenceMapperSharer1
  // 
  Self.PersistenceMapperSharer1.MapperProviderType := TypeOf(EcoPersistenceMapperProvider.TEcoPersistenceMapperProvider);
  // 
  // TSimpleEcoWebDemoEcoSpace
  // 
  Self.AllowDeactivateDirty := True;
  Self.PersistenceMapper := Self.PersistenceMapperSharer1;
end;

end.
